/* 
Statistik 7 (Vorlufige Schutzmanahmen) ab Berichtsjahr 2023
*/

select   year(m.bisdatum) as "Berichtsjahr",
         v.bereich as "Bereich",
         v.aktenzeichen as "Aktenzeichen",
         isnull(u.name,'') as "Sachbearbeiter",
         a.nachname as "Nachname_JM",
         a.vorname as "Vorname_JM",
         convert(char(10),p.geburtsdatum,104) as "GebDatJM",
         convert(char(10),m.vondatum,104) as "Beginn",
         convert(char(10),m.bisdatum,104) as "Ende", 
         
         substring(s.feld,13,5) as "LfdNr (nach bergabe)",
         substring(s.feld,18,20) as "Kennnummer (nach bergabe)" ,

-- Abschnitt Art des Trgers und der Manahme

(case when substring(s.feld,38,1) = '1' then 'Trger der ffentlichen Jugendhilfe'
      when substring(s.feld,38,1) = '2' then 'Trger der freien Jugendhilfe'
      else '(Angabe fehlt)' end) as "Art des Trgers",


(case when substring(s.feld,39,1) = '1' then 'Inobhutnahme  42 SGB VIII'
      when substring(s.feld,39,1) = '2' then 'Vorlufige Inobhutnahme  42a SGB VIII'
      else '(Angabe fehlt)' end) as "Art der Manahme",

(case when substring(s.feld,40,1) = '1' then 'ja'
      when substring(s.feld,40,1) = '2' then 'nein'
      else '(Angabe fehlt)' end) as "Vorh GefEinschtzung",
      
-- Abschnitt Angaben zum Kind oder Jugendlichen

(case when substring(s.feld,41,1) = '1' then 'mnnlich'
      when substring(s.feld,41,1) = '2' then 'weiblich'
      when substring(s.feld,41,1) = '3' then 'divers'
      when substring(s.feld,41,1) = '7' then 'ohne Angabe (nach Geburtenregister)'
      else '(Angabe fehlt)' end) as "Geschlecht",

(case when substring(s.feld,42,1) = '1' then 'unter 3 Jahren'
      when substring(s.feld,42,1) = '2' then '3 bis unter 6 Jahren'
      when substring(s.feld,42,1) = '3' then '6 bis unter 9 Jahren'
      when substring(s.feld,42,1) = '4' then '9 bis unter 12 Jahren'
      when substring(s.feld,42,1) = '5' then '12 bis unter 14 Jahren'
      when substring(s.feld,42,1) = '6' then '14 bis unter 16 Jahren'
      when substring(s.feld,42,1) = '7' then '16 bis unter 18 Jahren'
      else '(Angabe fehlt)' end) as "Alter",

(case when substring(s.feld,43,1) = '1' then 'ja'
      when substring(s.feld,43,1) = '2' then 'nein'
      else '(Angabe fehlt)' end) as "Ausl. Herkunft Elternteil",

(case when substring(s.feld,44,1) = '1' then 'Deutsch'
      when substring(s.feld,44,1) = '2' then 'Nicht deutsch'
      else '(Angabe fehlt)' end) as "Vorrang. Sprache",

(case when substring(s.feld,45,1) = '1' then 'Ja'
      when substring(s.feld,45,1) = '2' then 'Nein'
      else '(Angabe fehlt)' end) as "Wiederholte ION",

(case when substring(s.feld,46,2) = '01' then 'bei den Eltern'
      when substring(s.feld,46,2) = '02' then 'bei einem Elternteil mit Partner/-in'
      when substring(s.feld,46,2) = '03' then 'bei einem allein erziehendem Elternteil'
      when substring(s.feld,46,2) = '04' then 'bei Verwandten'
      when substring(s.feld,46,2) = '05' then 'in einer Pflegefamilie ( 33, 35a SGB VIII)'
      when substring(s.feld,46,2) = '06' then 'bei einer sonstigen Person'
      when substring(s.feld,46,2) = '07' then 'in einem Heim/einer sonstigen betreuten Wohnform ( 34, 35a SGB VIII)'
      when substring(s.feld,46,2) = '08' then 'in einer eigenen Wohnung/Wohngemeinschaft'
      when substring(s.feld,46,2) = '09' then 'in einer Aufnahmeeinrichtung/Gemeinschaftsunterkunft ( 44, 53 AsylG)'
      when substring(s.feld,46,2) = '10' then 'ohne feste Unterkunft'
      when substring(s.feld,46,2) = '11' then 'unbekannt/keine Angabe mglich'
      when substring(s.feld,46,2) = '12' then 'in einem Krankenhaus (nur bei anonymer Geburt/Babyklappe)'
      else '(Angabe fehlt)' end) as "Aufenth vor Manahme",

-- Abschnitt Angaben zu Beratung

(case when substring(s.feld,48,1) = '1' then 'bei einer geeigneten Person'
      when substring(s.feld,48,1) = '2' then 'in einer Einrichtung'
      when substring(s.feld,48,1) = '3' then 'in einer sonstigen betreuten Wohnform'
      else '(Angabe fehlt)' end) as "Unterbr whrend Man",

(case when substring(s.feld,49,2) = '01' then 'Minderjhrige/-r selbst'
      when substring(s.feld,49,2) = '02' then 'Eltern(-teil)/Personensorgeberechtigte/-r'
      when substring(s.feld,49,2) = '03' then 'Jugendamt/Sozialer Dienst'
      when substring(s.feld,49,2) = '04' then 'Polizei/Gericht/Staatsanwaltschaft'
      when substring(s.feld,49,2) = '05' then 'Schule'
      when substring(s.feld,49,2) = '06' then 'Gesundheitspersonal/Gesundheitswesen'
      when substring(s.feld,49,2) = '07' then 'Verwandte'
      when substring(s.feld,49,2) = '08' then 'Sonstige'
      when substring(s.feld,49,2) = '09' then 'Kindertageseinrichtung/Kindertagespflegeperson'
      when substring(s.feld,49,2) = '10' then 'Andere Einrichtung/anderer Dienst der Kinder- und Jugendhilfe'
      when substring(s.feld,49,2) = '11' then 'Bekannte/Nachbarn'
      when substring(s.feld,49,2) = '12' then 'Anonyme Meldung'
      else '(Angabe fehlt)' end) as "Hinweisgeb. Inst/Person",

(case when substring(s.feld,51,1) = '1' then 'Montag bis Freitag (ohne Feiertage)'
      when substring(s.feld,51,1) = '2' then 'Samstag, Sonntag und Feiertage'
      else '(Angabe fehlt)' end) as "Beginn Manahme",

(case when substring(s.feld,52,1) = '1' then '8 - 17 Uhr'
      when substring(s.feld,52,1) = '2' then '17 - 21 Uhr'
      when substring(s.feld,52,1) = '3' then '21 - 8 Uhr'
      else '(Angabe fehlt)' end) as "Beginnzeit Manahme",

(case when substring(s.feld,53,4) <> '   ' then substring(s.feld,53,4)
      else '(Angabe fehlt)' end) as "Dauer Manahme (Tage)",

(case when substring(s.feld,57,1) = '1' then 'jugendgefhrd. Ort nach vorh. Ausreien'
      when substring(s.feld,57,1) = '2' then 'jugendgefhrd. Ort ohne vorh. Ausreien'
      when substring(s.feld,57,1) = '3' then 'sonstiger Zugang nach vorh. Ausreien'
      when substring(s.feld,57,1) = '4' then 'sonstiger Zugang ohne vorh. Ausreien'
      else '(Angabe fehlt)' end) as "Anlass der Manahme",

(case when substring(s.feld,58,1) = '1' then 'ja' else 'nein' end) as "Integrationsprobleme",
(case when substring(s.feld,59,1) = '1' then 'ja' else 'nein' end) as "berforderung_Eltern",
(case when substring(s.feld,60,1) = '1' then 'ja' else 'nein' end) as "Schul_Ausbildungsprobleme",
(case when substring(s.feld,61,1) = '1' then 'ja' else 'nein' end) as "Vernachlssigung",
(case when substring(s.feld,62,1) = '1' then 'ja' else 'nein' end) as "Delinquenz Straftat",
(case when substring(s.feld,63,1) = '1' then 'ja' else 'nein' end) as "Suchtprobleme",
(case when substring(s.feld,64,1) = '1' then 'ja' else 'nein' end) as "Anz. krperl. Misshandlung",
(case when substring(s.feld,65,1) = '1' then 'ja' else 'nein' end) as "Anz. psych. Misshandlung",
(case when substring(s.feld,66,1) = '1' then 'ja' else 'nein' end) as "Anz. sex Gewalt",
(case when substring(s.feld,67,1) = '1' then 'ja' else 'nein' end) as "Trennung Scheidung Eltern",
(case when substring(s.feld,68,1) = '1' then 'ja' else 'nein' end) as "Wohnungsprobleme",
(case when substring(s.feld,69,1) = '1' then 'ja' else 'nein' end) as "unbegl Einreise",
(case when substring(s.feld,70,1) = '1' then 'ja' else 'nein' end) as "Beziehungsprobleme",
(case when substring(s.feld,71,1) = '1' then 'ja' else 'nein' end) as "sonstige Probleme",

(case when substring(s.feld,72,1) = '1' then 'Ja, wurde eingelegt'
      when substring(s.feld,72,1) = '2' then 'Nein, wurde nicht eingelegt'
      else '(Angabe fehlt)' end) as "Widerspruch",

(case when substring(s.feld,73,1) = '1' then 'Ja, wurde herbeigefhrt'
      when substring(s.feld,73,1) = '2' then 'Nein, wurde nicht herbeigefhrt'
      else '(Angabe fehlt)' end) as "Entscheidung FamG",

(case when substring(s.feld,74,2) in ('1 ',' 1') then 'Entscheidung JA zum anschl.Aufenth./weiteren Hilfen'
      when substring(s.feld,74,2) in ('2 ',' 2') then 'bernahme durch anderes JA (Zustndigkeitswechsel)'
      when substring(s.feld,74,2) = ' 5' then 'bernahme in eine ION nach  42 SGB VIII'
      when substring(s.feld,74,2) = ' 6' then 'Feststellung der Volljhrigkeit nach  42f SGB VIII'
      when substring(s.feld,74,2) in ('3 ',' 3') then 'Beendigung durch Mdj. selbst (z.B. Ausreien)'
      when substring(s.feld,74,2) in ('4 ',' 4') then 'keine der zuvor genannten Antworten (z.B. berfhrung in JVA)'
      else '(Angabe fehlt)' end) as "Manahme endete mit",

(case when substring(s.feld,76,1) = '1' then 'am gleichen Ort wie vor der Man.'
      when substring(s.feld,76,1) = '2' then 'an anderem Ort wie vor der Man.'
      else '(Angabe fehlt)' end) as "Man.ende mit Unterbringg.",

(case when substring(s.feld,77,2) = '01' then 'bei den Eltern (auch Fam.zusammenfhrung)'
      when substring(s.feld,77,2) = '02' then 'bei einem Elternteil mit Partner/-in'
      when substring(s.feld,77,2) = '03' then 'bei einem alleinerziehenden Elternteil'
      when substring(s.feld,77,2) = '04' then 'bei Verwandten'
      when substring(s.feld,77,2) = '05' then 'in einer (anderen) Pflegefamilie ( 33, 35a SGB VIII)'
      when substring(s.feld,77,2) = '06' then 'bei einer (anderen) sonstigen Person'
      when substring(s.feld,77,2) = '07' then 'in einer (anderen) eigenen Wohnung/Wohngemeinschaft'
      when substring(s.feld,77,2) = '08' then 'in einer Aufnahmeeinrichtung/Gemeinschaftsunterkunft ( 44, 53 AsylG)'
      when substring(s.feld,77,2) = '09' then 'in einem (anderen) Heim/einer sonstigen betreuten Wohnform / 34, 35a SGB VIII)'
      when substring(s.feld,77,2) = '10' then 'in einer sonstigen Einrichtung'
      else '(Angabe fehlt)' end) as "Unterbringg. nach Man.ende",

(case when substring(s.feld,78,1) = '1' then 'ja' else 'nein' end) as "Fortf. Erziehungsberatung",
(case when substring(s.feld,79,1) = '1' then 'ja' else 'nein' end) as "Fortf. amb./teilstat. Hilfe",
(case when substring(s.feld,80,1) = '1' then 'ja' else 'nein' end) as "Fortf. andere amb./teilstat. Hilfe",
(case when substring(s.feld,81,1) = '1' then 'ja' else 'nein' end) as "Fortf. vorbergeh. stat. Hilfe",
(case when substring(s.feld,82,1) = '1' then 'ja' else 'nein' end) as "Keine Fortf./keine og. Hilfe",

(case when substring(s.feld,83,1) = '1' then 'ja' else 'nein' end) as "Neue Erziehungsberatung",
(case when substring(s.feld,84,1) = '1' then 'ja' else 'nein' end) as "Neue amb./teilstat. Hilfe",
(case when substring(s.feld,85,1) = '1' then 'ja' else 'nein' end) as "Neue andere amb./teilstat. Hilfe",
(case when substring(s.feld,86,1) = '1' then 'ja' else 'nein' end) as "Neue vorbergeh. stat. Hilfe",
(case when substring(s.feld,87,1) = '1' then 'ja' else 'nein' end) as "Keine neue/keine og. Hilfe",

isnull((case when s.freigabe = '0' then 'nein'
      when s.freigabe = '1' then 'ja'
      end),'') as "freigegeben",

isnull((case when s.uebergabe = '0' then 'nein'
      when s.uebergabe = '1' then 'ja'
      end),'') as "bergeben"
      
from  n_vorgang v left join n_benutzer u on v.sachbearbeiter = u.lfdnr
                  inner join n_vorgbeteiligte b on v.vorgangsnummer = b.vorgang and b.beteiligtenart = 7
                  inner join n_adressen a on b.adresse = a.adressnummer
                  inner join n_personendaten p on b.adresse = p.zuordnungsnummer
                  inner join n_vorgmassnahme h on v.vorgangsnummer = h.vorgang
                  inner join n_massnahme m on h.massnahme = m.massnahmennummer
                  inner join n_statistikbogen s on h.massnahme = s.aktion      

where year(m.bisdatum) >= 2023

order by 1,3,4,5,6